<?php
#
#  cumuluswebtags.txt (Cumulus) - Last modified: 16 Jan 2010 @ 17h03
#
// Author: Ray Beriau
// Version 1.00 - 10-Aug-2009 -- created this tag list
// Version 1.01 - 17-Aug-2009 -- added missing tags
// Version 1.02 - 02-Sep-2009 -- slight modifications to the header
// Version 1.03 - 13-Nov-2009 -- added new tags
// Version 1.04 - 15-Nov-2009 -- corrected comments on a tag
// Version 1.05 - 14-Dec-2009 -- new tag added
// Version 1.06 - 16-Dec-2009 -- new tag added
// Version 1.07 - 22-Dec-2009 -- new tag added
// Version 1.08 - 23-Dec-2009 -- new tag added, missing tags added
// Version 1.09 - 11-Jan-2010 -- modified Davis battery tags
// Version 1.10 - 16-Jan-2010 -- added new altimeter pressure tag
// Version 1.11 - 26-Jan-2010 -- added new currcond tag
// ------------------------------------------------------------------------------------------------
// allow viewing of generated source

if ( isset($_REQUEST['source']) && strtolower($_REQUEST['source']) == 'view' ) {
//--self downloader --
   $filenameReal = __FILE__;
   $download_size = filesize($filenameReal);
   header('Pragma: public');
   header('Cache-Control: private');
   header('Cache-Control: no-cache, must-revalidate');
   header('Content-type: text/plain');
   header('Accept-Ranges: bytes');
   header('Content-Length: $download_size');
   header('Connection: close');

   readfile($filenameReal);
   exit;
}

// If you don't want to use the standard web pages provided with Cumulus, you can design your own
// and have Cumulus automatically insert the data into them before uploading them to your web site.
// You do this by using HTML-transparent tags in your HTML, in the form
//
//    
//
// Immediately before uploading the file, Cumulus will replace the tag with the current value of the
// item the tag represents. When you put a tag into your HTML, be careful that whatever program you
// are using to develop your web pages doesn't change the angle brackets to &lt; and &gt; which some
// programs seem to do!

// General or Non Weather Specific Tags
// ====================================================================================================================
$time                 = "17:00 on 16 november 2012";  //  the current date and time (example format: 18:30 on 25 Dec 2009)
$day                  = "16";  //  the current day as a 2-digit number (example format: 25)
$dayname              = "fredag";  //  the current day as a word (example format: Friday)
$shortdayname         = "fr";  //  the current day as a shortened word (example format: Fri)
$month                = "11";  //  the current month as a 2-digit number (example format: 12)
$monthname            = "november";  //  the current month as a word (example format: December)
$shortmonthname       = "nov";  //  the current month as a shortened word (example format: Dec)
$year                 = "2012";  //  the current year as a 4-digit number (example format: 2009 or yyyy)
$shortyear            = "12";  //  the current year as a 2-digit number (example format: 09 or yy)
$hour                 = "17";  //  the current hour as a 2-digit number (example format: 23)
$minute               = "00";  //  the current minute as a 2-digit number (example format: 59)
$date                 = "2012-11-16";  //  the current date (example format: 12/25/2010 or mm/dd/yyyy)

$forecast             = "Fairly fine, showers likely";  //  the current forecast (example format: Fine weather
$forecastnumber       = "11";  // the number relating to the current forecast entry in the 'strings.ini' file
//                        // see 'samplestrings.ini' for a list - negative means 'Exceptional' - zero means no Cumulus forecast

$temp                 = "5,8";  //  the outside temperature (example format: 15.5)
$intemp               = "22,8";  //  the inside temperature (example format: 22.5)
$temptrend            = "-0,4";  //  the change in temperature over the last hour
$temptrendtext        = "Falling";  //  temperature change over the last hour - Rising/Falling/Steady
//                        // (for use by javascript gauges, values can't be changed)
$temptrendenglish     = "Falling"; // temperature change over the last hour - Rising/Falling/Steady

$hum                  = "99";  //  the outside humidity (example format: 85)
$inhum                = "44";  //  the inside humidity (example format: 55)

$heatindex            = "5,8";  //  current heat index
$humidex              = "5,8";  //  current humidex - see this entry in Wikipedia

$press                = "1014,5";  //  the sea level pressure (example format: 1015.15)
$presstrend           = "Falling slowly";  //  the pressure trend in words - values can be set in the 'strings.ini' file
//                        // (for use by javascript gauges, values can't be changed)
$presstrendenglish    = "Falling";  //  simple pressure trend - Rising/Falling/Steady
$presstrendval        = "-0,1";  //  the pressure trend in figures (example format: +0.01)
$altimeterpressure    = "1014,5";  //  the altimeter pressure (example format: 1015.15)

$dew                  = "5,7";  //  the outside dew point (example format: 13.5)

$wspeed               = "2,3";  //  the current wind speed reading (example format: 0.0)
$wlatest              = "4,8";  //  latest wind speed reading from console (example format: 0.0)
$wgust                = "5,4";  //  the current wind gust reading (example format: 1.5)
$wchill               = "4,0";  //  the current wind chill temperature (example format: 14.5)

$bearing              = "225";  //  the current wind bearing
$avgbearing           = "215";  //  average wind bearing over last 10 minutes (example format: 100)
$wdir                 = "SW";  //  average wind bearing as a compass point (example format: ESE)

$beaufort             = "F2";  //  the wind speed on the Beaufort scale (example format: F8)
$beaudesc             = "Light breeze";  //  the wind speed Beaufort description (example format: Gale)

$currcond             = "";  // The current condition as set within Cumulus

// Comma separated list of recent wind bearing readings (up to 3600 entries).
// This is a circular buffer; to find the most recent value use nextwindindex.
// ====================================================================================================================
$wdirdata             = "180,180,180,180,180,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,180,180,180,180,180,180,180,180,180,180,180,180,180,180,180,180,180,180,180,248,248,248,248,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,248,248,248,248,225,225,225,225,225,225,225,225,225,225,270,270,270,270,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,180,180,180,180,180,360,360,360,360,360,270,270,270,270,270,225,225,225,225,225,225,225,225,225,225,225,225,225,225,270,270,270,270,270,270,270,270,270,270,248,248,248,248,270,270,270,270,270,270,270,270,270,270,270,270,270,270,270,248,248,248,248,248,248,248,248,248,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,270,270,270,270,270,225,225,225,225,225,180,180,180,180,180,180,180,180,180,180,180,180,180,180,180,180,180,180,180,225,225,225,225,225,225,225,225,225,225,270,270,270,270,225,225,225,225,225,225,225,225,225,202,202,202,202,202,270,270,270,270,270,225,225,225,225,315,315,315,315,315,225,225,225,225,225,202,202,202,202,202,225,225,225,225,225,225,225,225,225,270,270,270,270,270,225,225,225,225,225,180,180,180,180,180,225,225,225,225,225,225,225,225,225,248,248,248,248,248,180,180,180,180,180,248,248,248,248,248,225,225,225,225,225,248,248,248,248,202,202,202,202,202,248,248,248,248,248,202,202,202,202,202,270,270,270,270,270,225,225,225,225,270,270,270,270,270,225,225,225,225,225,180,180,180,180,180,225,225,225,225,225,225,225,225,225,270,270,270,270,270,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,248,248,248,248,225,225,225,225,225,225,225,225,225,225,225,225,225,225,248,248,248,248,248,225,225,225,225,225,225,225,225,225,270,270,270,270,270,202,202,202,202,202,225,225,225,225,225,180,180,180,180,225,225,225,225,225,225,225,225,225,225,248,248,248,248,248,248,248,248,248,248,248,248,248,248,225,225,225,225,225,270,270,270,270,270,270,270,270,270,270,270,270,270,270,225,225,225,225,225,248,248,248,248,248,225,225,225,225,225,180,180,180,180,180,270,270,270,270,270,270,270,270,270,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,202,202,202,202,202,225,225,225,225,225,248,248,248,248,248,225,225,225,225,225,225,225,225,225,270,270,270,270,270,270,270,270,270,270,180,180,180,180,180,225,225,225,225,225,225,225,225,225,225,225,225,225,202,202,202,202,202,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,270,270,270,270,270,225,225,225,225,225,180,180,180,180,270,270,270,270,270,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,248,248,248,248,248,225,225,225,225,225,180,180,180,180,180,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,248,248,248,248,248,225,225,225,225,225,225,225,225,225,225,180,180,180,180,225,225,225,225,225,225,225,225,225,225,270,270,270,270,270,225,225,225,225,225,225,225,225,248,248,248,248,248,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,270,270,270,270,270,225,225,225,225,225,225,225,225,225,270,270,270,270,270,270,270,270,270,270,225,225,225,225,225,225,225,225,225,248,248,248,248,248,225,225,225,225,225,225,225,225,225,225,248,248,248,248,248,225,225,225,225,225,225,225,225,225,225,225,225,225,225,180,180,180,180,180,180,180,180,180,180,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,248,248,248,248,248,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,248,248,248,248,248,248,248,248,248,248,248,248,248,248,248,248,248,248,248,225,225,225,225,225,180,180,180,180,225,225,225,225,225,225,225,225,225,225,270,270,270,270,270,270,270,270,270,270,270,270,270,270,270,270,270,270,270,270,270,270,270,270,270,270,270,270,270,270,270,270,270,270,270,270,270,270,270,270,270,270,270,270,270,270,270,270,202,202,202,202,202,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,248,248,248,248,248,225,225,225,225,225,248,248,248,248,202,202,202,202,202,22,22,22,22,22,225,225,225,225,225,225,225,225,225,225,248,248,248,248,248,248,248,248,248,248,248,248,248,248,248,248,248,248,202,202,202,202,202,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,202,202,202,202,202,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,248,248,248,248,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,248,248,248,248,248,248,248,248,248,248,248,248,248,248,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,248,248,248,248,248,225,225,225,225,225,225,225,225,225,225,225,225,225,225,248,248,248,248,248,248,248,248,248,248,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,180,180,180,180,180,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,180,180,180,180,180,225,225,225,225,225,225,225,225,225,225,270,270,270,270,270,270,270,270,270,270,270,270,270,270,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,270,270,270,270,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,270,270,270,270,270,248,248,248,248,248,248,248,248,248,248,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,248,248,248,248,248,225,225,225,225,225,225,225,225,225,225,225,225,225,225,180,180,180,180,180,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,202,202,202,202,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,248,248,248,248,248,248,248,248,248,248,202,202,202,202,202,225,225,225,225,225,270,270,270,270,270,270,270,270,270,248,248,248,248,248,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,180,180,180,180,225,225,225,225,225,225,225,225,225,225,270,270,270,270,270,202,202,202,202,202,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,270,270,270,270,270,270,270,270,270,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,248,248,248,248,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,202,202,202,202,202,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,202,202,202,202,202,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,248,248,248,248,248,248,248,248,248,248,248,248,248,248,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,202,202,202,202,202,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,270,270,270,270,270,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,202,202,202,202,202,225,225,225,225,225,225,225,225,225,225,225,225,225,225,248,248,248,248,248,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,270,270,270,270,270,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,180,180,180,180,180,270,270,270,270,270,225,225,225,225,225,270,270,270,270,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,180,180,180,180,180,248,248,248,248,248,180,180,180,180,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,248,248,248,248,248,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,180,180,180,180,180,248,248,248,248,248,225,225,225,225,225,225,225,225,225,180,180,180,180,180,225,225,225,225,225,158,158,158,158,158,225,225,225,225,225,180,180,180,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,202,202,202,202,180,180,180,180,180,180,180,180,180,180,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,202,202,202,202,202,225,225,225,225,225,225,225,225,225,225,270,270,270,270,270,270,270,270,270,202,202,202,202,202,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,202,202,202,202,202,202,202,202,202,202,225,225,225,225,225,180,180,180,180,180,180,180,180,180,202,202,202,202,202,202,202,202,202,202,202,202,202,202,202,225,225,225,225,225,225,225,225,225,225,225,225,225,225,180,180,180,180,180,180,180,180,180,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,202,202,202,202,202,225,225,225,225,225,202,202,202,202,202,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,180,180,180,180,180,225,225,225,225,225,225,225,225,225,202,202,202,202,202,202,202,202,202,202,225,225,225,225,225,225,225,225,225,225,225,225,225,225,180,180,180,180,180,180,180,180,180,180,180,180,180,180,180,180,180,180,180,180,180,180,180,180,180,180,180,180,180,180,180,180,180,180,225,225,225,225,225,225,225,225,225,180,180,180,180,180,180,180,180,180,180,225,225,225,225,225,225,225,225,225,270,270,270,270,270,248,248,248,248,248,180,180,180,180,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,315,315,315,315,315,248,248,248,248,248,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,270,270,270,270,180,180,180,180,180,202,202,202,202,202,225,225,225,225,225,270,270,270,270,270,225,225,225,225,180,180,180,180,180,225,225,225,225,225,270,270,270,270,270";

// Comma separated list of recent wind speed readings (up to 3600 entries).
// This is a circular buffer; to find the most recent value use nextwindindex.
// ====================================================================================================================
$wspddata             = "3,1,3.1,3.1,3.1,3.1,3.4,3.4,3.4,3.4,2.4,2.4,2.4,2.4,2.4,3.1,3.1,3.1,3.1,3.1,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.4,2.4,2.4,2.4,2.0,2.0,2.0,2.0,2.0,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,3.7,3.7,3.7,3.7,3.4,3.4,3.4,3.4,3.4,2.0,2.0,2.0,2.0,2.0,2.4,2.4,2.4,2.4,2.4,2.0,2.0,2.0,2.0,2.0,2.4,2.4,2.4,2.4,1.7,1.7,1.7,1.7,1.7,1.7,1.7,1.7,1.7,1.7,1.7,1.7,1.7,1.7,2.0,2.0,2.0,2.0,2.0,2.7,2.7,2.7,2.7,3.4,3.4,3.4,3.4,3.4,3.4,3.4,3.4,3.4,3.4,3.4,3.4,3.4,3.4,3.4,2.4,2.4,2.4,2.4,2.4,1.7,1.7,1.7,1.7,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.7,2.7,2.7,2.7,2.7,2.7,2.7,2.7,2.7,2.7,1.7,1.7,1.7,1.7,1.4,1.4,1.4,1.4,1.4,1.4,1.4,1.4,1.4,1.4,2.4,2.4,2.4,2.4,2.4,1.7,1.7,1.7,1.7,1.7,1.7,1.7,1.7,1.7,1.7,1.7,1.7,1.7,1.7,1.4,1.4,1.4,1.4,1.4,2.7,2.7,2.7,2.7,2.7,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.0,2.0,2.0,2.0,2.0,2.7,2.7,2.7,2.7,2.7,1.4,1.4,1.4,1.4,1.4,2.0,2.0,2.0,2.0,2.0,2.7,2.7,2.7,2.7,2.4,2.4,2.4,2.4,2.4,2.0,2.0,2.0,2.0,2.0,2.4,2.4,2.4,2.4,2.4,2.0,2.0,2.0,2.0,2.0,1.7,1.7,1.7,1.7,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.4,2.4,2.4,2.4,2.4,2.0,2.0,2.0,2.0,3.1,3.1,3.1,3.1,2.4,2.4,2.4,2.4,2.4,4.4,4.4,4.4,4.4,4.4,2.7,2.7,2.7,2.7,2.7,1.7,1.7,1.7,1.7,2.7,2.7,2.7,2.7,2.7,2.4,2.4,2.4,2.4,2.4,2.7,2.7,2.7,2.7,2.7,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.7,2.7,2.7,2.7,2.7,2.7,2.7,2.7,2.7,2.7,4.1,4.1,4.1,4.1,4.1,2.7,2.7,2.7,2.7,2.7,3.1,3.1,3.1,3.1,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,3.1,3.1,3.1,3.1,3.1,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,3.1,3.1,3.1,3.1,3.1,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,3.4,3.4,3.4,3.4,3.4,2.4,2.4,2.4,2.4,3.7,3.7,3.7,3.7,3.7,2.7,2.7,2.7,2.7,2.7,2.4,2.4,2.4,2.4,2.4,2.7,2.7,2.7,2.7,2.7,2.7,2.7,2.7,2.7,2.0,2.0,2.0,2.0,2.0,2.7,2.7,2.7,2.7,2.7,2.0,2.0,2.0,2.0,2.0,3.1,3.1,3.1,3.1,3.1,2.7,2.7,2.7,2.7,2.7,2.7,2.7,2.7,2.7,2.0,2.0,2.0,2.0,3.1,3.1,3.1,3.1,3.1,2.0,2.0,2.0,2.0,2.0,2.4,2.4,2.4,2.4,2.0,2.0,2.0,2.0,2.0,2.4,2.4,2.4,2.4,2.4,2.7,2.7,2.7,2.7,2.7,4.1,4.1,4.1,4.1,4.1,2.7,2.7,2.7,2.7,2.4,2.4,2.4,2.4,2.4,2.0,2.0,2.0,2.0,2.0,1.4,1.4,1.4,1.4,1.4,1.7,1.7,1.7,1.7,1.7,1.7,1.7,1.7,1.7,1.7,1.7,1.7,1.7,1.7,2.7,2.7,2.7,2.7,2.7,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,3.4,3.4,3.4,3.4,3.4,2.4,2.4,2.4,2.4,2.4,3.7,3.7,3.7,3.7,3.7,3.4,3.4,3.4,3.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,3.1,3.1,3.1,3.1,3.1,1.7,1.7,1.7,1.7,1.7,1.7,1.7,1.7,1.7,2.4,2.4,2.4,2.4,2.4,3.4,3.4,3.4,3.4,3.4,2.4,2.4,2.4,2.4,2.4,1.7,1.7,1.7,1.7,2.7,2.7,2.7,2.7,2.7,1.7,1.7,1.7,1.7,1.7,1.7,1.7,1.7,1.7,1.7,2.4,2.4,2.4,2.4,2.4,4.4,4.4,4.4,4.4,1.7,1.7,1.7,1.7,1.7,1.7,1.7,1.7,1.7,3.4,3.4,3.4,3.4,3.4,1.7,1.7,1.7,1.7,1.7,2.0,2.0,2.0,2.0,2.4,2.4,2.4,2.4,2.4,3.1,3.1,3.1,3.1,3.1,1.7,1.7,1.7,1.7,1.7,2.7,2.7,2.7,2.7,2.7,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,1.7,1.7,1.7,1.7,1.7,2.0,2.0,2.0,2.0,2.0,2.4,2.4,2.4,2.4,2.4,3.1,3.1,3.1,3.1,2.7,2.7,2.7,2.7,2.7,2.0,2.0,2.0,2.0,2.0,2.7,2.7,2.7,2.7,2.7,3.1,3.1,3.1,3.1,3.1,3.4,3.4,3.4,3.4,3.1,3.1,3.1,3.1,3.1,2.4,2.4,2.4,2.4,2.4,2.0,2.0,2.0,2.0,2.0,3.4,3.4,3.4,3.4,3.4,2.4,2.4,2.4,2.4,3.4,3.4,3.4,3.4,3.4,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.4,2.4,2.4,2.4,3.4,3.4,3.4,3.4,3.4,2.7,2.7,2.7,2.7,2.7,2.7,2.7,2.7,2.7,2.7,2.0,2.0,2.0,2.0,2.0,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,5.4,5.4,5.4,5.4,5.1,5.1,5.1,5.1,5.1,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.7,2.7,2.7,2.7,2.7,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.7,2.7,2.7,2.7,2.7,2.4,2.4,2.4,2.4,2.0,2.0,2.0,2.0,2.0,2.4,2.4,2.4,2.4,2.4,2.0,2.0,2.0,2.0,2.0,2.4,2.4,2.4,2.4,2.4,2.7,2.7,2.7,2.7,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.7,2.7,2.7,2.7,2.7,3.1,3.1,3.1,3.1,3.1,2.7,2.7,2.7,2.7,2.7,2.7,2.7,2.7,2.7,2.7,2.7,2.7,2.7,2.7,2.7,2.7,2.7,2.7,2.7,1.7,1.7,1.7,1.7,1.7,1.7,1.7,1.7,1.7,1.7,2.0,2.0,2.0,2.0,2.0,1.7,1.7,1.7,1.7,2.4,2.4,2.4,2.4,2.4,1.4,1.4,1.4,1.4,1.4,4.1,4.1,4.1,4.1,4.1,3.7,3.7,3.7,3.7,3.7,2.0,2.0,2.0,2.0,2.7,2.7,2.7,2.7,2.7,2.7,2.7,2.7,2.7,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.0,2.0,2.0,2.0,2.0,1.7,1.7,1.7,1.7,1.7,1.7,1.7,1.7,1.7,1.7,2.0,2.0,2.0,2.0,1.7,1.7,1.7,1.7,1.7,1.7,1.7,1.7,1.7,1.7,3.1,3.1,3.1,3.1,3.1,2.0,2.0,2.0,2.0,2.0,3.1,3.1,3.1,3.1,2.4,2.4,2.4,2.4,2.4,2.0,2.0,2.0,2.0,2.0,1.7,1.7,1.7,1.7,1.7,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,1.4,1.4,1.4,1.4,1.4,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.4,2.4,2.4,2.4,2.4,1.7,1.7,1.7,1.7,1.7,1.7,1.7,1.7,1.7,1.7,1.7,1.7,1.7,1.7,2.7,2.7,2.7,2.7,2.7,2.0,2.0,2.0,2.0,2.0,1.7,1.7,1.7,1.7,2.0,2.0,2.0,2.0,2.0,1.7,1.7,1.7,1.7,1.7,2.0,2.0,2.0,2.0,2.0,4.1,4.1,4.1,4.1,4.1,2.7,2.7,2.7,2.7,2.0,2.0,2.0,2.0,2.0,3.4,3.4,3.4,3.4,3.4,3.1,3.1,3.1,3.1,3.1,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.4,2.4,2.4,2.4,2.4,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,1.7,1.7,1.7,1.7,1.4,1.4,1.4,1.4,1.4,1.7,1.7,1.7,1.7,1.7,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,1.4,1.4,1.4,1.4,1.4,1.4,1.4,1.4,1.4,2.4,2.4,2.4,2.4,2.4,2.7,2.7,2.7,2.7,2.7,2.0,2.0,2.0,2.0,1.7,1.7,1.7,1.7,1.7,1.7,1.7,1.7,1.7,1.7,1.7,1.7,1.7,1.7,1.7,1.4,1.4,1.4,1.4,1.4,1.7,1.7,1.7,1.7,1.4,1.4,1.4,1.4,1.4,1.7,1.7,1.7,1.7,1.7,1.7,1.7,1.7,1.7,1.7,1.7,1.7,1.7,1.7,1.7,2.4,2.4,2.4,2.4,1.7,1.7,1.7,1.7,1.7,1.7,1.7,1.7,1.7,1.7,2.0,2.0,2.0,2.0,2.0,3.4,3.4,3.4,3.4,3.4,2.0,2.0,2.0,2.0,1.7,1.7,1.7,1.7,1.7,2.0,2.0,2.0,2.0,2.0,1.4,1.4,1.4,1.4,1.4,2.0,2.0,2.0,2.0,2.0,1.7,1.7,1.7,1.7,1.4,1.4,1.4,1.4,1.4,1.4,1.4,1.4,1.4,1.4,1.0,1.0,1.0,1.0,1.0,1.7,1.7,1.7,1.7,2.0,2.0,2.0,2.0,3.1,3.1,3.1,3.1,3.1,2.0,2.0,2.0,2.0,2.0,1.4,1.4,1.4,1.4,1.4,2.0,2.0,2.0,2.0,2.0,1.7,1.7,1.7,1.7,2.0,2.0,2.0,2.0,2.0,1.7,1.7,1.7,1.7,1.7,2.0,2.0,2.0,2.0,2.0,1.4,1.4,1.4,1.4,1.4,2.4,2.4,2.4,2.4,2.0,2.0,2.0,2.0,2.0,2.4,2.4,2.4,2.4,2.4,3.7,3.7,3.7,3.7,3.7,1.7,1.7,1.7,1.7,1.7,1.7,1.7,1.7,1.7,3.1,3.1,3.1,3.1,3.1,2.0,2.0,2.0,2.0,2.0,2.7,2.7,2.7,2.7,2.7,2.4,2.4,2.4,2.4,2.0,2.0,2.0,2.0,2.0,2.4,2.4,2.4,2.4,2.4,2.0,2.0,2.0,2.0,2.0,1.7,1.7,1.7,1.7,1.7,4.8,4.8,4.8,4.8,3.1,3.1,3.1,3.1,3.1,2.7,2.7,2.7,2.7,2.7,1.7,1.7,1.7,1.7,1.7,3.1,3.1,3.1,3.1,3.1,2.7,2.7,2.7,2.7,1.7,1.7,1.7,1.7,1.7,2.7,2.7,2.7,2.7,2.7,2.7,2.7,2.7,2.7,2.7,3.4,3.4,3.4,3.4,3.4,1.4,1.4,1.4,1.4,2.4,2.4,2.4,2.4,2.4,1.7,1.7,1.7,1.7,1.4,1.4,1.4,1.4,1.4,1.0,1.0,1.0,1.0,1.0,2.0,2.0,2.0,2.0,3.1,3.1,3.1,3.1,3.1,3.7,3.7,3.7,3.7,3.7,2.0,2.0,2.0,2.0,2.0,2.7,2.7,2.7,2.7,2.7,1.4,1.4,1.4,1.4,2.4,2.4,2.4,2.4,2.4,2.7,2.7,2.7,2.7,2.7,1.4,1.4,1.4,1.4,1.4,2.0,2.0,2.0,2.0,2.0,1.4,1.4,1.4,1.4,2.0,2.0,2.0,2.0,2.0,1.4,1.4,1.4,1.4,1.4,2.7,2.7,2.7,2.7,2.7,2.7,2.7,2.7,2.7,2.7,2.4,2.4,2.4,2.4,2.7,2.7,2.7,2.7,2.7,1.7,1.7,1.7,1.7,1.7,1.7,1.7,1.7,1.7,1.7,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.7,2.7,2.7,2.7,2.7,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,1.4,1.4,1.4,1.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,1.7,1.7,1.7,1.7,1.7,2.7,2.7,2.7,2.7,4.1,4.1,4.1,4.1,4.1,2.7,2.7,2.7,2.7,2.7,1.7,1.7,1.7,1.7,1.7,2.4,2.4,2.4,2.4,2.4,4.4,4.4,4.4,4.4,1.4,1.4,1.4,1.4,1.4,1.4,1.4,1.4,1.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,3.7,3.7,3.7,3.7,1.4,1.4,1.4,1.4,1.4,1.7,1.7,1.7,1.7,1.7,2.0,2.0,2.0,2.0,2.0,1.7,1.7,1.7,1.7,1.7,2.0,2.0,2.0,2.0,3.1,3.1,3.1,3.1,3.1,2.0,2.0,2.0,2.0,2.0,1.7,1.7,1.7,1.7,1.7,1.4,1.4,1.4,1.4,1.4,1.7,1.7,1.7,1.7,1.7,1.7,1.7,1.7,1.7,1.4,1.4,1.4,1.4,1.4,1.4,1.4,1.4,1.4,1.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,1.4,1.4,1.4,1.4,1.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.0,2.0,2.0,2.0,1.7,1.7,1.7,1.7,1.7,3.1,3.1,3.1,3.1,3.1,2.4,2.4,2.4,2.4,2.4,2.0,2.0,2.0,2.0,2.0,2.4,2.4,2.4,2.4,2.0,2.0,2.0,2.0,2.0,1.4,1.4,1.4,1.4,1.4,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.4,2.4,2.4,2.4,2.4,2.7,2.7,2.7,2.7,2.7,2.7,2.7,2.7,2.7,2.0,2.0,2.0,2.0,2.0,2.7,2.7,2.7,2.7,1.7,1.7,1.7,1.7,1.7,2.0,2.0,2.0,2.0,2.0,1.7,1.7,1.7,1.7,1.7,3.4,3.4,3.4,3.4,2.7,2.7,2.7,2.7,2.7,1.7,1.7,1.7,1.7,1.7,2.4,2.4,2.4,2.4,2.4,2.7,2.7,2.7,2.7,2.7,2.7,2.7,2.7,2.7,3.1,3.1,3.1,3.1,3.1,2.7,2.7,2.7,2.7,2.7,3.4,3.4,3.4,3.4,3.4,2.0,2.0,2.0,2.0,2.0,2.4,2.4,2.4,2.4,1.7,1.7,1.7,1.7,1.7,1.4,1.4,1.4,1.4,1.4,1.7,1.7,1.7,1.7,1.7,2.0,2.0,2.0,2.0,2.0,2.4,2.4,2.4,2.4,1.4,1.4,1.4,1.4,1.4,1.7,1.7,1.7,1.7,1.7,1.0,1.0,1.0,1.0,1.0,1.7,1.7,1.7,1.7,1.7,2.7,2.7,2.7,2.7,2.7,2.7,2.7,2.7,2.7,2.7,2.7,2.7,2.7,2.7,1.7,1.7,1.7,1.7,1.7,2.0,2.0,2.0,2.0,2.0,3.7,3.7,3.7,3.7,2.7,2.7,2.7,2.7,2.7,2.4,2.4,2.4,2.4,2.4,1.7,1.7,1.7,1.7,1.7,1.4,1.4,1.4,1.4,1.4,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,1.7,1.7,1.7,1.7,1.7,2.7,2.7,2.7,2.7,2.7,2.4,2.4,2.4,2.4,2.7,2.7,2.7,2.7,2.7,2.4,2.4,2.4,2.4,2.4,2.7,2.7,2.7,2.7,2.7,2.4,2.4,2.4,2.4,2.4,1.7,1.7,1.7,1.7,1.7,1.7,1.7,1.7,1.7,2.4,2.4,2.4,2.4,2.4,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,3.4,3.4,3.4,3.4,2.4,2.4,2.4,2.4,2.4,3.1,3.1,3.1,3.1,3.1,1.7,1.7,1.7,1.7,1.7,2.4,2.4,2.4,2.4,3.1,3.1,3.1,3.1,3.1,3.4,3.4,3.4,3.4,3.4,3.1,3.1,3.1,3.1,3.1,2.7,2.7,2.7,2.7,2.7,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,1.4,1.4,1.4,1.4,1.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,1.7,1.7,1.7,1.7,1.7,2.4,2.4,2.4,2.4,2.4,2.0,2.0,2.0,2.0,2.0,1.4,1.4,1.4,1.4,1.4,1.4,1.4,1.4,1.4,2.4,2.4,2.4,2.4,2.4,1.7,1.7,1.7,1.7,1.7,2.4,2.4,2.4,2.4,2.4,1.7,1.7,1.7,1.7,1.7,1.7,1.7,1.7,1.7,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,1.7,1.7,1.7,1.7,1.7,1.7,1.7,1.7,1.7,1.7,3.1,3.1,3.1,3.1,2.0,2.0,2.0,2.0,2.0,3.4,3.4,3.4,3.4,3.4,2.4,2.4,2.4,2.4,2.4,1.7,1.7,1.7,1.7,1.7,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.7,2.7,2.7,2.7,2.7,1.7,1.7,1.7,1.7,1.7,3.4,3.4,3.4,3.4,3.4,3.4,3.4,3.4,3.4,2.7,2.7,2.7,2.7,2.7,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.0,2.0,2.0,2.0,2.0,1.7,1.7,1.7,1.7,1.7,2.0,2.0,2.0,2.0,2.0,2.7,2.7,2.7,2.7,2.7,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.7,2.7,2.7,2.7,2.7,2.4,2.4,2.4,2.4,2.4,2.7,2.7,2.7,2.7,2.0,2.0,2.0,2.0,2.0,2.4,2.4,2.4,2.4,2.4,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.7,2.7,2.7,2.7,2.7,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,3.4,3.4,3.4,3.4,2.0,2.0,2.0,2.0,2.0,2.4,2.4,2.4,2.4,2.4,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,1.7,1.7,1.7,1.7,2.0,2.0,2.0,2.0,2.0,1.7,1.7,1.7,1.7,1.7,1.7,1.7,1.7,1.7,1.7,1.7,1.7,1.7,1.7,1.7,2.0,2.0,2.0,2.0,2.7,2.7,2.7,2.7,2.7,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,3.1,3.1,3.1,3.1,3.1,2.0,2.0,2.0,2.0,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,1.7,1.7,1.7,1.7,1.7,1.7,1.7,1.7,1.7,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.7,2.7,2.7,2.7,2.7,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.7,2.7,2.7,2.7,2.7,2.4,2.4,2.4,2.4,2.4,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,3.1,3.1,3.1,3.1,3.1,2.0,2.0,2.0,2.0,2.0,2.7,2.7,2.7,2.7,2.7,2.0,2.0,2.0,2.0,2.0,3.4,3.4,3.4,3.4,1.7,1.7,1.7,1.7,1.7,2.7,2.7,2.7,2.7,2.7,2.7,2.7,2.7,2.7,2.7,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.0,2.0,2.0,2.0,2.0,2.4,2.4,2.4,2.4,2.4,2.0,2.0,2.0,2.0,2.0,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.0,2.0,2.0,2.0,2.0,2.7,2.7,2.7,2.7,2.7,3.1,3.1,3.1,3.1,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,4.1,4.1,4.1,4.1,4.1,2.0,2.0,2.0,2.0,2.0,3.4,3.4,3.4,3.4,3.4,3.4,3.4,3.4,3.4,3.4,3.4,3.4,3.4,3.4,3.4,3.4,3.4,3.4,3.4,2.4,2.4,2.4,2.4,2.4,2.7,2.7,2.7,2.7,3.1,3.1,3.1,3.1,3.1,3.4,3.4,3.4,3.4,3.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,3.4,3.4,3.4,3.4,3.4,3.4,3.4,3.4,2.7,2.7,2.7,2.7,2.7,2.4,2.4,2.4,2.4,2.4,2.7,2.7,2.7,2.7,2.7,3.1,3.1,3.1,3.1,3.7,3.7,3.7,3.7,3.7,3.4,3.4,3.4,3.4,3.4,2.7,2.7,2.7,2.7,2.7,2.7,2.7,2.7,2.7,3.1,3.1,3.1,3.1,3.1,3.1,3.1,3.1,3.1,3.1,3.1,3.1,3.1,3.1,3.1,3.7,3.7,3.7,3.7,3.7,2.4,2.4,2.4,2.4,2.7,2.7,2.7,2.7,2.7,2.4,2.4,2.4,2.4,2.4,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,3.1,3.1,3.1,3.1,3.1,3.1,3.1,3.1,3.1,3.1,3.1,3.1,3.1,3.1,2.7,2.7,2.7,2.7,2.7,3.1,3.1,3.1,3.1,3.1,2.7,2.7,2.7,2.7,2.7,2.7,2.7,2.7,2.7,3.7,3.7,3.7,3.7,3.7,3.1,3.1,3.1,3.1,3.1,2.7,2.7,2.7,2.7,2.7,3.4,3.4,3.4,3.4,2.4,2.4,2.4,2.4,2.4,3.4,3.4,3.4,3.4,3.4,2.4,2.4,2.4,2.4,2.4,2.7,2.7,2.7,2.7,2.7,2.0,2.0,2.0,2.0,3.7,3.7,3.7,3.7,3.7,2.4,2.4,2.4,2.4,2.4,2.7,2.7,2.7,2.7,3.4,3.4,3.4,3.4,3.4,2.7,2.7,2.7,2.7,2.4,2.4,2.4,2.4,2.4,4.4,4.4,4.4,4.4,4.4,3.4,3.4,3.4,3.4,3.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,3.1,3.1,3.1,3.1,3.1,3.4,3.4,3.4,3.4,3.4,3.1,3.1,3.1,3.1,3.1,3.7,3.7,3.7,3.7,3.7,3.4,3.4,3.4,3.4,2.7,2.7,2.7,2.7,2.7,3.7,3.7,3.7,3.7,3.7,3.1,3.1,3.1,3.1,3.1,3.4,3.4,3.4,3.4,3.4,3.1,3.1,3.1,3.1,2.7,2.7,2.7,2.7,2.7,3.4,3.4,3.4,3.4,3.4,3.4,3.4,3.4,3.4,3.4,3.1,3.1,3.1,3.1,3.7,3.7,3.7,3.7,3.7,3.4,3.4,3.4,3.4,3.4,3.1,3.1,3.1,3.1,3.1,2.4,2.4,2.4,2.4,2.4,4.4,4.4,4.4,4.4,4.4,4.4,4.4,4.4,4.4,5.4,5.4,5.4,5.4,5.4,5.4,5.4,5.4,5.4,5.4,5.4,5.4,5.4,5.4,5.4,3.7,3.7,3.7,3.7,4.1,4.1,4.1,4.1,4.1,3.7,3.7,3.7,3.7,3.7,2.7,2.7,2.7,2.7,2.7,3.4,3.4,3.4,3.4,3.4,3.7,3.7,3.7,3.7,2.7,2.7,2.7,2.7,2.7,4.1,4.1,4.1,4.1,3.1,3.1,3.1,3.1,3.1,3.4,3.4,3.4,3.4,3.4,4.8,4.8,4.8,4.8,2.7,2.7,2.7,2.7,2.7,4.1,4.1,4.1,4.1,4.1,3.4,3.4,3.4,3.4,3.4,3.4,3.4,3.4,3.4,3.4,5.4,5.4,5.4,5.4,4.8,2.4,2.4,2.4,2.0,2.0,2.0,2.0,2.0,1.7,1.7,1.7,1.7,1.7,1.7,1.7,1.7,1.7,1.7,3.1,3.1,3.1,3.1,2.0,2.0,2.0,2.0,2.0,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,3.4,3.4,3.4,3.4,3.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.7,2.7,2.7,2.7,2.4,2.4,2.4,2.4,2.4,2.0,2.0,2.0,2.0,2.0,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,1.7,1.7,1.7,1.7,1.7,2.0,2.0,2.0,2.0,2.0,2.4,2.4,2.4,2.4,2.0,2.0,2.0,2.0,2.0,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.0,2.0,2.0,2.0,2.0,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.0,2.0,2.0,2.0,2.0,2.7,2.7,2.7,2.7,2.7,2.4,2.4,2.4,2.4,4.4,4.4,4.4,4.4,3.4,3.4,3.4,3.4,3.4,2.4,2.4,2.4,2.4,2.4,2.7,2.7,2.7,2.7,2.7,2.4,2.4,2.4,2.4,2.4,2.7,2.7,2.7,2.7,2.7,2.7,2.7,2.7,2.7,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.7,2.7,2.7,2.7,2.7,3.1,3.1,3.1,3.1,2.4,2.4,2.4,2.4,2.4,3.1,3.1,3.1,3.1,3.1,2.4,2.4,2.4,2.4,2.4,3.1,3.1,3.1,3.1,3.1,2.7,2.7,2.7,2.7,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,3.1,3.1,3.1,3.1,3.1,3.1,3.1,3.1,3.1,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.4,2.7,2.7,2.7,2.7,4.1,4.1,4.1,4.1,4.1,2.4,2.4,2.4,2.4,2.4,2.7,2.7,2.7,2.7,2.7,3.7,3.7,3.7,3.7,3.7,4.4,4.4,4.4,4.4,3.4,3.4,3.4,3.4,3.4,4.4,4.4,4.4,4.4,4.4,4.1,4.1,4.1,4.1,3.4,3.4,3.4,3.4,3.4,2.0,2.0,2.0,2.0,2.7,2.7,2.7,2.7,2.7,2.4,2.4,2.4,2.4,2.4,2.7,2.7,2.7,2.7,2.7,2.4,2.4,2.4,2.4,2.4,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,3.1,3.1,3.1,3.1,3.1,2.4,2.4,2.4,2.4,2.4,2.0,2.0,2.0,2.0,2.0,2.7,2.7,2.7,2.7,2.0,2.0,2.0,2.0,2.0,1.7,1.7,1.7,1.7,1.7,2.4,2.4,2.4,2.4,2.4,3.7,3.7,3.7,3.7,3.7,3.1,3.1,3.1,3.1,2.7,2.7,2.7,2.7,2.7,2.4,2.4,2.4,2.4,2.4,3.7,3.7,3.7,3.7,3.7";

// The index of the entries in wdirdata and wspddata which Cumulus is going to use next -
// i.e. the latest entry used is one less than this; but don't forget to allow for the wrap around!
// ====================================================================================================================
$nextwindindex        = "3162";

$windrun              = "77,0";  //  the total wind run today so far
$windrunY             = "135,1";  //  the total wind run for yesterday

$rrate                = "0,0";  //  the current rainfall rate
$rfall                = "0,0";  //  the total rainfall so far today
$rfallY               = "0,9";  //  the total rainfall for yesterday

$rmidnight            = "0,0";  //  the total rainfall since midnight - useful if you don't use midnight as your start of day

$rhour                = "0,0";  //  the rainfall in the last hour
$rmonth               = "29,1";  //  the total rainfall so far this month
$ryear                = "894,4";  //  the total rainfall so far this year

$battery              = "0v";  //  the console battery condition for Davis (only) weather stations
$txbattery            = "No status";  //  the transmitter ISS battery condition for Davis (only) weather stations

$cloudbase            = "58 ft";  //  calculated cloud base
$ET                   = "0,00";  //  today's evapotranspiration
$UV                   = "0,0";  //  current uv index
$SolarRad             = "0";  //  current solar radiation

// There are a set of tags for today's highs and lows, e.g. <tempTH> is today's high temperature,
// and <tempTL> is today's low temperature; <TtempTH> is the time at which today's high
// temperature occurred, and so on. The full list of this set of tags follows; you should be able to
// work out what they represent from their names:
// ====================================================================================================================
$tempTH               = "7,6";  //  today's high temperature
$TtempTH              = "13:26";  //  time at which today's high temperature occured
$tempTL               = "2,0";  //  today's low temperature
$TtempTL              = "01:52";  //  time at which today's low temperature occured
$tempYH               = "10,3";  //  yesterday's highs
$TtempYH              = "12:07";  // time at which yesterday's high temperature occured
$tempYL               = "2,3";  //  yesterday's lows
$TtempYL              = "00:00";  // time at which yesterday's low temperature occured

$pressTH              = "1016,0";  //  today's high pressure
$TpressTH             = "00:00";  //  time at which today's high pressure occured
$pressTL              = "1014,2";  //  today's low pressure
$TpressTL             = "05:57";  //  time at which today's low pressure occured
$pressYH              = "1016,1";  //  yesterday's high pressure
$TpressYH             = "21:22";  // time at which yesterday's high pressure occured
$pressYL              = "1009,6";  //  yesterday's low pressure
$TpressYL             = "03:55";  //  time at which yesterday's low pressure occured

$windTM               = "2,4";  //  today's high wind
$TwindTM              = "16:53";  //  time at which today's low wind occured
$windYM               = "3,4";  //  yesterday's high wind
$TwindYM              = "02:42";  //  time at which yesterday's low wind occured

$wgustTM              = "5,8";  //  today's high wind gust
$TwgustTM             = "04:20";  //  time at which today's high wind gust occured
$wgustYM              = "8,5";  //  yesterday's high wind gust
$TwgustYM             = "02:58";  //  time at which yesterday's high wind gust occured

$rrateTM              = "0,0";  //  today's high rainfall rate
$TrrateTM             = "00:00";  //  time at which today's high rainfall rate occured
$rrateYM              = "10,3";  //  yesterday's high rainfall rate
$TrrateYM             = "05:09";  //  time at which yesterday's high rainfall rate occured

$bearingTM            = "225";  //  time at which the current wind bearing occured
$bearingYM            = "225";  //  yesterday's wind bearing

$Tbeaufort            = "F2";  //  today's high beaufort (wind speed)
$Ybeaufort            = "F3";  //  yesterday's high beaufort (wind speed)

// There are a corresponding set of tags for yesterday's highs and lows, e.g. <tempYH>,
// and another set for the all time highs and lows,  as follows:
// ====================================================================================================================
$tempH                = "34,8";  //  all time high temperature
$TtempH               = "at 15:08 on 12 juli 2010";  //  time at which all time high temperature occured
$mintempH             = "20,1";  //  all time high minimum temperature
$TmintempH            = "at 00:00 on 12 juli 2010";  //  time at which all time high minimum temperature occured

$tempL                = "-22,4";  //  all time low temperature
$TtempL               = "at 07:05 on 22 februari 2010";  //  time at which all time low temperature occured
$maxtempL             = "-12,3";  //  all time low maximum temperature
$TmaxtempL            = "at 00:00 on 22 december 2010";  //  time at which all time low maximum temperature occured

$gustM                = "14,6";  //  all time high wind gust
$TgustM               = "at 15:46 on 13 september 2012";  //  time at which all time high wind gust occured
$wspeedH              = "10,2";  //  all time high average wind speed
$TwspeedH             = "at 20:24 on 25 december 2009";  //  time at which all time high average wind speed occured
$wchillH              = "-29,2";  //  all time greatest wind chill (i.e. lowest temperature)
$TwchillH             = "at 06:02 on 22 februari 2010";  //  time at which all time greatest wind chill occured (i.e. lowest temperature)
$rrateM               = "123,0";  //  all time high rain rate
$TrrateM              = "at 12:59 on 08 augusti 2012";  //  time at which all time high rain rate occured
$rfallH               = "45,3";  //  all time high daily rain
$TrfallH              = "on 31 augusti 2012";  //  time at which all time high daily rain occured
$rfallhH              = "23,9";  //  all time high hourly rain
$TrfallhH             = "at 13:51 on 08 augusti 2012";  //  time at which all time high hourly rain occured
$rfallmH              = "205,2";  //  all time high monthly rain
$TrfallmH             = "juni 2012";  //  time at which all time high monthly rain occured
$pressH               = "1040,0";  //  all time high pressure
$TpressH              = "at 21:10 on 29 januari 2012";  //  time at which all time high pressure occured
$pressL               = "950,6";  //  all time low pressure
$TpressL              = "at 20:20 on 25 februari 2010";  //  time at which all time low pressure occured

// Each of the above has a corresponding date/time tag, e.g. <TtempH>
// ====================================================================================================================
// There are a set of tags giving the data units in use:
$tempunit             = "&deg;C";  //  temperature units
$pressunit            = "hPa";  //  pressure units
$windunit             = "m/s";  //  wind speed units
$windrununit          = "km";  //  wind run units
$rainunit             = "mm";  //  rainfall units

// There are a set of tags for the WMR928 extra sensors:
// ====================================================================================================================
$ExtraTemp1           = "0,0";  //  extra temperature channel 1
$ExtraTemp2           = "0,0";  //  extra temperature channel 2
$ExtraTemp3           = "0,0";  //  extra temperature channel 3
$ExtraDP1             = "0,0";  //  extra dew point channel 1
$ExtraDP2             = "0,0";  //  extra dew point channel 2
$ExtraDP3             = "0,0";  //  extra dew point channel 3
$ExtraHum1            = "0";  //  extra humidity channel 1
$ExtraHum2            = "0";  //  extra humidity channel 2
$ExtraHum3            = "0";  //  extra humidity channel 3

// There are a set of tags for the Cumulus alarm states. They give a value of '1' if the alarm has been set
// and the alarm condition is currently met; otherwise '0'.
// ====================================================================================================================
$LowTempAlarm         = "0";  //  low temperature alarm
$HighTempAlarm        = "0";  //  high temperature alarm
$LowPressAlarm        = "0";  //  low pressure alarm
$HighPressAlarm       = "0";  //  high pressure alarm
$HighRainTodayAlarm   = "0";  //  high rain today alarm
$HighRainRateAlarm    = "0";  //  high rainfall rate alarm
$HighWindGustAlarm    = "0";  // high wind gust alarm
$HighWindSpeedAlarm   = "0";  //  high wind speed alarm

// There are a set of tags where the decimal comma has been replaced with a full stop, where necessary,
// for use with gauges which do not like the commas. They all correspond to the same tag with 'RC' removed.
// ====================================================================================================================
$RCtemp               = "5.8";  //  outside temperature
$RCintemp             = "22.8";  //  inside temperature
$RCtempTH             = "7.6";  //  today's high outside temperature
$RCtempTL             = "2.0";  //  today's high outside temperature
$RCheatindex          = "5.8";  //  heat index
$RCdew                = "5.7";  //  dew point
$RChum                = "99";  //  outside humidity
$RCinhum              = "44";  //  inside humidity
$RCpress              = "1014.5";  //  pressure
$RCpressTH            = "1016.0";  //  time at which today's high pressure
$RCpressTL            = "1014.2";  //  low pressure
$RCrfall              = "0.0";  //  rainfall
$RCrrate              = "0.0";  //  rainfall rate
$RCrrateTM            = "0.0";  //  time at which today's rainfall rate
$RCwspeed             = "2.3";  //  wind speed reading
$RCwgust              = "5.4";  //  wind gust reading
$RCwgustTM            = "5.8";  //  today's wind gust reading
$RCwchill             = "4.0";  //  wind chill temperature

// Finally, there are some miscellaneous tags:
// ====================================================================================================================
$version              = "1.9.2";  //  the version of cumulus in use
$build                = "1032";  //  the build of cumulus in use
$interval             = "30";  //  the web site update interval
$update               = "2012-11-16 17:00:03";  //  the date and time of the last web site update
$stationtype          = "PowerWeatherStation";  //  the type of station in use
$latitude             = "N&nbsp;59&deg;&nbsp;13&#39;&nbsp;19&quot;";  //  the station latitude
$longitude            = "E&nbsp;18&deg;&nbsp;18&#39;&nbsp;18&quot;";  //  the station longitude
$altitude             = "60&nbsp;m";  //  the station altitude
$location             = "Bergholmen";  //  the station location
$longlocation         = "Bergholmen";  //  longer description of the station location

$sunrise              = "07:43";  //  current sunrise time at the station
$sunset               = "15:19";  //  current sunset time at the station
$daylength            = "07:36";  //  length of day in hours and minutes (sunrise to sunset)
$tomorrowdaylength    = "There will be 4min 25s less daylight tomorrow";  //  string giving the difference between the length of day today and tomorrow
$dawn                 = "06:55";  //  start of civil twilight at the station
$dusk                 = "16:07";  //  end of civil twilight at the station

$isdaylight           = "0";
//                        // flag to indicate if the location for the station is in daylight or not,
//                        // based on the dawn and dusk times. Possible values are 0 or 1,
//                        // where 1 notes that it is currently within the hours of daylight.
$daylightlength       = "09:12";  //  length of daylight in hours and minutes (dawn to dusk)
$moonphase            = "Waxing Crescent";  //  current phase of the moon
$moonrise             = "10:43";  //  current moonrise time at the station
$moonset              = "17:40";  //  current moonset time at the station
$forum                = ':<a href="http://sandaysoft.com/forum/">forum</a>:';  //  URL of the forum
$webcam               = '';  //  URL of the webcam
$recordsbegandate     = "10 oktober 2009";  //  the date that the all time records began
$graphperiod          = "24";  //  the number of hours displayed by the graphs
$realtimeinterval     = "600";  //  the realtime update interval in seconds
$rollovertime         = "midnight";  //  the time that the logs rollover to the next day: 'Midnight', '9 am' or '10 am'
$sensorcontactlost    = "";  // 1 if the station has lost contact with its remote sensors (Fine Offset only)
$snowdepth            = "0"; // today's snow depth as entered manually in the Weather Diary
// ====================================================================================================================
//
?>